/**********************************************************************************************************************************
 ***  This program creates the 2019-20 Private School Survey (PSS) public-use data file with permanently assigned formats.      ***
 ***                                                                                                                            ***
 ***  NOTES: You will have to change the FILENAME, LIBNAME, and %INCLUDE assignments below to match the location of your data   ***
 ***         and programs.                                                                                                      ***
 ***                                                                                                                            ***
 ***         The SAS code below was written for SAS v9.2 or above. Labels were given a maximun length of 60 characters. If you  ***
 ***         are using SAS v7 or below, you should be aware that labels could be truncated to 40 characters. If so, you may     ***
 ***         wish to abbreviate labels so that they are unique and are descriptive.                                             ***
 ***                                                                                                                            ***
 ***         There may be missing data for some institutions due to parent-child relations.                                     ***
 ***                                                                                                                            ***
 ***  PROGRAM: Create PU 2019-20 PSS SAS Dataset.sas                                                                            ***
 ***  AUTHOR:  National Center for Education Statistics                                                                         ***
 ***  DATE:    April 16, 2021                                                                                                   ***
 **********************************************************************************************************************************/

/* Specify location of input CSV dataset */
filename rawdata 'C:\NCES\PSS\2019-20\Data\pss1920_pu.csv';

/* Specify location of SAS Format catalog */
libname library 'C:\NCES\PSS\2019-20\Data';

/* Specify location output SAS dataset */
libname pss 'C:\NCES\PSS\2019-20\Data';

/* Include the SAS program to create the user-defined formats */
%include 'C:\NCES\PSS\2019-20\Programs\Create PU 2019-20 PSS SAS Formats.sas';

/* Read CSV data */
data pss.pss1920_pu;
   infile rawdata delimiter = ',' missover dsd lrecl=32767 firstobs=2;

   /* Assign input formats */
   informat PFNLWT best32.
            REPW1 best32.
            REPW2 best32.
            REPW3 best32.
            REPW4 best32.
            REPW5 best32.
            REPW6 best32.
            REPW7 best32.
            REPW8 best32.
            REPW9 best32.
            REPW10 best32.
            REPW11 best32.
            REPW12 best32.
            REPW13 best32.
            REPW14 best32.
            REPW15 best32.
            REPW16 best32.
            REPW17 best32.
            REPW18 best32.
            REPW19 best32.
            REPW20 best32.
            REPW21 best32.
            REPW22 best32.
            REPW23 best32.
            REPW24 best32.
            REPW25 best32.
            REPW26 best32.
            REPW27 best32.
            REPW28 best32.
            REPW29 best32.
            REPW30 best32.
            REPW31 best32.
            REPW32 best32.
            REPW33 best32.
            REPW34 best32.
            REPW35 best32.
            REPW36 best32.
            REPW37 best32.
            REPW38 best32.
            REPW39 best32.
            REPW40 best32.
            REPW41 best32.
            REPW42 best32.
            REPW43 best32.
            REPW44 best32.
            REPW45 best32.
            REPW46 best32.
            REPW47 best32.
            REPW48 best32.
            REPW49 best32.
            REPW50 best32.
            REPW51 best32.
            REPW52 best32.
            REPW53 best32.
            REPW54 best32.
            REPW55 best32.
            REPW56 best32.
            REPW57 best32.
            REPW58 best32.
            REPW59 best32.
            REPW60 best32.
            REPW61 best32.
            REPW62 best32.
            REPW63 best32.
            REPW64 best32.
            REPW65 best32.
            REPW66 best32.
            REPW67 best32.
            REPW68 best32.
            REPW69 best32.
            REPW70 best32.
            REPW71 best32.
            REPW72 best32.
            REPW73 best32.
            REPW74 best32.
            REPW75 best32.
            REPW76 best32.
            REPW77 best32.
            REPW78 best32.
            REPW79 best32.
            REPW80 best32.
            REPW81 best32.
            REPW82 best32.
            REPW83 best32.
            REPW84 best32.
            REPW85 best32.
            REPW86 best32.
            REPW87 best32.
            REPW88 best32.
            CSOURCE best32.
            P135 best32.
            P140 best32.
            P145 best32.
            P150 best32.
            P155 best32.
            P160 best32.
            P165 best32.
            P170 best32.
            P175 best32.
            P180 best32.
            P185 best32.
            P190 best32.
            P195 best32.
            P200 best32.
            P205 best32.
            P210 best32.
            P215 best32.
            P220 best32.
            P225 best32.
            P230 best32.
            P235 best32.
            P240 best32.
            P245 best32.
            P250 best32.
            P255 best32.
            P260 best32.
            P265 best32.
            P270 best32.
            P275 best32.
            P280 best32.
            P285 best32.
            P290 best32.
            P295 best32.
            P300 best32.
            P305 best32.
            P320 best32.
            P330 best32.
            P325 best32.
            P316 best32.
            P318 best32.
            P310 best32.
            P332 best32.
            P335 best32.
            P340 best32.
            P345 best32.
            P350 best32.
            P360 best32.
            P365 best32.
            P370 best32.
            P385 best32.
            P390 best32.
            P395 best32.
            P400 best32.
            P405 best32.
            P410 best32.
            P415 best32.
            P420 best32.
            P425 best32.
            P430 best32.
            P435 best32.
            P440 best32.
            P445 best32.
            P450 best32.
            P455 best32.
            P460 best32.
            P465 best32.
            P467 best32.
            P468 best32.
            P470 best32.
            P475 best32.
            P480 best32.
            P485 best32.
            P490 best32.
            P492 best32.
            P495 best32.
            P500 best32.
            P505 best32.
            P510 best32.
            P515 best32.
            P520 best32.
            P523 best32.
            P530 best32.
            P535 best32.
            P540 best32.
            P542 best32.
            P545 best32.
            P550 best32.
            P555 best32.
            P575 best32.
            P580 best32.
            P585 best32.
            P590 best32.
            P600 best32.
            P602 best32.
            P605 best32.
            P610 best32.
            P620 best32.
            P622 best32.
            P630 best32.
            P635 best32.
            P640 best32.
            P645 best32.
            P650 best32.
            P655 best32.
            P660 best32.
            PPIN $8.
            PINST $50.
            PADDRS $50.
            PCITY $28.
            PSTABB $2.
            PZIP $5.
            PZIP4 $4.
            PPHONE $10.
            PCNTY $3.
            PCNTY20 $5.
            PCNTNM $40.
            PL_ADD $50.
            PL_CIT $28.
            PL_STABB $2.
            PL_ZIP $5.
            PL_ZIP4 $4.
            REGION best32.
            PSTANSI $2.
            ULOCALE20 best32.
            LATITUDE20 best32.
            LONGITUDE20 best32.
            SLDLST20 $5.
            SLDUST20 $5.
            STCD20 $4.
            LOGR2020 best32.
            HIGR2020 best32.
            FRAME $4.
            TABFLAG best32.
            TYPOLOGY best32.
            RELIG best32.
            ORIENT best32.
            DIOCESE $4.
            LEVEL best32.
            LEVEL2 best32.
            NUMSTUDS best32.
            SIZE best32.
            NUMTEACH best32.
            UCOMMTYP best32.
            TOTHRS best32.
            MALES best32.
            F_P135 best32.
            F_P140 best32.
            F_P145 best32.
            F_P150 best32.
            F_P155 best32.
            F_P160 best32.
            F_P165 best32.
            F_P170 best32.
            F_P175 best32.
            F_P180 best32.
            F_P185 best32.
            F_P190 best32.
            F_P195 best32.
            F_P200 best32.
            F_P205 best32.
            F_P210 best32.
            F_P215 best32.
            F_P220 best32.
            F_P225 best32.
            F_P230 best32.
            F_P235 best32.
            F_P240 best32.
            F_P245 best32.
            F_P250 best32.
            F_P255 best32.
            F_P260 best32.
            F_P265 best32.
            F_P270 best32.
            F_P275 best32.
            F_P280 best32.
            F_P285 best32.
            F_P290 best32.
            F_P295 best32.
            F_P300 best32.
            F_P305 best32.
            F_P320 best32.
            F_P330 best32.
            F_P325 best32.
            F_P316 best32.
            F_P318 best32.
            F_P310 best32.
            F_P332 best32.
            F_P335 best32.
            F_P340 best32.
            F_P345 best32.
            F_P350 best32.
            F_P360 best32.
            F_P365 best32.
            F_P370 best32.
            F_P385 best32.
            F_P390 best32.
            F_P395 best32.
            F_P400 best32.
            F_P405 best32.
            F_P410 best32.
            F_P415 best32.
            F_P420 best32.
            F_P425 best32.
            F_P430 best32.
            F_P435 best32.
            F_P440 best32.
            F_P445 best32.
            F_P450 best32.
            F_P455 best32.
            F_P460 best32.
            F_P465 best32.
            F_P467 best32.
            F_P468 best32.
            F_P470 best32.
            F_P475 best32.
            F_P480 best32.
            F_P485 best32.
            F_P490 best32.
            F_P492 best32.
            F_P495 best32.
            F_P500 best32.
            F_P505 best32.
            F_P510 best32.
            F_P515 best32.
            F_P520 best32.
            F_P523 best32.
            F_P530 best32.
            F_P535 best32.
            F_P540 best32.
            F_P542 best32.
            F_P545 best32.
            F_P550 best32.
            F_P555 best32.
            F_P575 best32.
            F_P580 best32.
            F_P585 best32.
            F_P590 best32.
            F_P600 best32.
            F_P602 best32.
            F_P605 best32.
            F_P610 best32.
            F_P620 best32.
            F_P622 best32.
            F_P630 best32.
            F_P635 best32.
            F_P640 best32.
            F_P645 best32.
            F_P650 best32.
            F_P655 best32.
            F_P660 best32.
            S_KG best32.
            P_INDIAN best32.
            P_ASIAN best32.
            P_PACIFIC best32.
            P_HISP best32.
            P_WHITE best32.
            P_BLACK best32.
            P_TR best32.
            STTCH_RT best32.;

   /* Define variables */
   input PFNLWT
         REPW1
         REPW2
         REPW3
         REPW4
         REPW5
         REPW6
         REPW7
         REPW8
         REPW9
         REPW10
         REPW11
         REPW12
         REPW13
         REPW14
         REPW15
         REPW16
         REPW17
         REPW18
         REPW19
         REPW20
         REPW21
         REPW22
         REPW23
         REPW24
         REPW25
         REPW26
         REPW27
         REPW28
         REPW29
         REPW30
         REPW31
         REPW32
         REPW33
         REPW34
         REPW35
         REPW36
         REPW37
         REPW38
         REPW39
         REPW40
         REPW41
         REPW42
         REPW43
         REPW44
         REPW45
         REPW46
         REPW47
         REPW48
         REPW49
         REPW50
         REPW51
         REPW52
         REPW53
         REPW54
         REPW55
         REPW56
         REPW57
         REPW58
         REPW59
         REPW60
         REPW61
         REPW62
         REPW63
         REPW64
         REPW65
         REPW66
         REPW67
         REPW68
         REPW69
         REPW70
         REPW71
         REPW72
         REPW73
         REPW74
         REPW75
         REPW76
         REPW77
         REPW78
         REPW79
         REPW80
         REPW81
         REPW82
         REPW83
         REPW84
         REPW85
         REPW86
         REPW87
         REPW88
         CSOURCE
         P135
         P140
         P145
         P150
         P155
         P160
         P165
         P170
         P175
         P180
         P185
         P190
         P195
         P200
         P205
         P210
         P215
         P220
         P225
         P230
         P235
         P240
         P245
         P250
         P255
         P260
         P265
         P270
         P275
         P280
         P285
         P290
         P295
         P300
         P305
         P320
         P330
         P325
         P316
         P318
         P310
         P332
         P335
         P340
         P345
         P350
         P360
         P365
         P370
         P385
         P390
         P395
         P400
         P405
         P410
         P415
         P420
         P425
         P430
         P435
         P440
         P445
         P450
         P455
         P460
         P465
         P467
         P468
         P470
         P475
         P480
         P485
         P490
         P492
         P495
         P500
         P505
         P510
         P515
         P520
         P523
         P530
         P535
         P540
         P542
         P545
         P550
         P555
         P575
         P580
         P585
         P590
         P600
         P602
         P605
         P610
         P620
         P622
         P630
         P635
         P640
         P645
         P650
         P655
         P660
         PPIN $
         PINST $
         PADDRS $
         PCITY $
         PSTABB $
         PZIP $
         PZIP4 $
         PPHONE $
         PCNTY $
         PCNTY20 $
         PCNTNM $
         PL_ADD $
         PL_CIT $
         PL_STABB $
         PL_ZIP $
         PL_ZIP4 $
         REGION
         PSTANSI $
         ULOCALE20
         LATITUDE20
         LONGITUDE20
         SLDLST20 $
         SLDUST20 $
         STCD20 $
         LOGR2020
         HIGR2020
         FRAME $
         TABFLAG
         TYPOLOGY
         RELIG
         ORIENT
         DIOCESE $
         LEVEL
         LEVEL2
         NUMSTUDS
         SIZE
         NUMTEACH
         UCOMMTYP
         TOTHRS
         MALES
         F_P135
         F_P140
         F_P145
         F_P150
         F_P155
         F_P160
         F_P165
         F_P170
         F_P175
         F_P180
         F_P185
         F_P190
         F_P195
         F_P200
         F_P205
         F_P210
         F_P215
         F_P220
         F_P225
         F_P230
         F_P235
         F_P240
         F_P245
         F_P250
         F_P255
         F_P260
         F_P265
         F_P270
         F_P275
         F_P280
         F_P285
         F_P290
         F_P295
         F_P300
         F_P305
         F_P320
         F_P330
         F_P325
         F_P316
         F_P318
         F_P310
         F_P332
         F_P335
         F_P340
         F_P345
         F_P350
         F_P360
         F_P365
         F_P370
         F_P385
         F_P390
         F_P395
         F_P400
         F_P405
         F_P410
         F_P415
         F_P420
         F_P425
         F_P430
         F_P435
         F_P440
         F_P445
         F_P450
         F_P455
         F_P460
         F_P465
         F_P467
         F_P468
         F_P470
         F_P475
         F_P480
         F_P485
         F_P490
         F_P492
         F_P495
         F_P500
         F_P505
         F_P510
         F_P515
         F_P520
         F_P523
         F_P530
         F_P535
         F_P540
         F_P542
         F_P545
         F_P550
         F_P555
         F_P575
         F_P580
         F_P585
         F_P590
         F_P600
         F_P602
         F_P605
         F_P610
         F_P620
         F_P622
         F_P630
         F_P635
         F_P640
         F_P645
         F_P650
         F_P655
         F_P660
         S_KG
         P_INDIAN
         P_ASIAN
         P_PACIFIC
         P_HISP
         P_WHITE
         P_BLACK
         P_TR
         STTCH_RT;

   /* Create variable labels */
   label PFNLWT       = 'Final Weight for School'
         REPW1        = 'Replicate Weight 1'
         REPW2        = 'Replicate Weight 2'
         REPW3        = 'Replicate Weight 3'
         REPW4        = 'Replicate Weight 4'
         REPW5        = 'Replicate Weight 5'
         REPW6        = 'Replicate Weight 6'
         REPW7        = 'Replicate Weight 7'
         REPW8        = 'Replicate Weight 8'
         REPW9        = 'Replicate Weight 9'
         REPW10       = 'Replicate Weight 10'
         REPW11       = 'Replicate Weight 11'
         REPW12       = 'Replicate Weight 12'
         REPW13       = 'Replicate Weight 13'
         REPW14       = 'Replicate Weight 14'
         REPW15       = 'Replicate Weight 15'
         REPW16       = 'Replicate Weight 16'
         REPW17       = 'Replicate Weight 17'
         REPW18       = 'Replicate Weight 18'
         REPW19       = 'Replicate Weight 19'
         REPW20       = 'Replicate Weight 20'
         REPW21       = 'Replicate Weight 21'
         REPW22       = 'Replicate Weight 22'
         REPW23       = 'Replicate Weight 23'
         REPW24       = 'Replicate Weight 24'
         REPW25       = 'Replicate Weight 25'
         REPW26       = 'Replicate Weight 26'
         REPW27       = 'Replicate Weight 27'
         REPW28       = 'Replicate Weight 28'
         REPW29       = 'Replicate Weight 29'
         REPW30       = 'Replicate Weight 30'
         REPW31       = 'Replicate Weight 31'
         REPW32       = 'Replicate Weight 32'
         REPW33       = 'Replicate Weight 33'
         REPW34       = 'Replicate Weight 34'
         REPW35       = 'Replicate Weight 35'
         REPW36       = 'Replicate Weight 36'
         REPW37       = 'Replicate Weight 37'
         REPW38       = 'Replicate Weight 38'
         REPW39       = 'Replicate Weight 39'
         REPW40       = 'Replicate Weight 40'
         REPW41       = 'Replicate Weight 41'
         REPW42       = 'Replicate Weight 42'
         REPW43       = 'Replicate Weight 43'
         REPW44       = 'Replicate Weight 44'
         REPW45       = 'Replicate Weight 45'
         REPW46       = 'Replicate Weight 46'
         REPW47       = 'Replicate Weight 47'
         REPW48       = 'Replicate Weight 48'
         REPW49       = 'Replicate Weight 49'
         REPW50       = 'Replicate Weight 50'
         REPW51       = 'Replicate Weight 51'
         REPW52       = 'Replicate Weight 52'
         REPW53       = 'Replicate Weight 53'
         REPW54       = 'Replicate Weight 54'
         REPW55       = 'Replicate Weight 55'
         REPW56       = 'Replicate Weight 56'
         REPW57       = 'Replicate Weight 57'
         REPW58       = 'Replicate Weight 58'
         REPW59       = 'Replicate Weight 59'
         REPW60       = 'Replicate Weight 60'
         REPW61       = 'Replicate Weight 61'
         REPW62       = 'Replicate Weight 62'
         REPW63       = 'Replicate Weight 63'
         REPW64       = 'Replicate Weight 64'
         REPW65       = 'Replicate Weight 65'
         REPW66       = 'Replicate Weight 66'
         REPW67       = 'Replicate Weight 67'
         REPW68       = 'Replicate Weight 68'
         REPW69       = 'Replicate Weight 69'
         REPW70       = 'Replicate Weight 70'
         REPW71       = 'Replicate Weight 71'
         REPW72       = 'Replicate Weight 72'
         REPW73       = 'Replicate Weight 73'
         REPW74       = 'Replicate Weight 74'
         REPW75       = 'Replicate Weight 75'
         REPW76       = 'Replicate Weight 76'
         REPW77       = 'Replicate Weight 77'
         REPW78       = 'Replicate Weight 78'
         REPW79       = 'Replicate Weight 79'
         REPW80       = 'Replicate Weight 80'
         REPW81       = 'Replicate Weight 81'
         REPW82       = 'Replicate Weight 82'
         REPW83       = 'Replicate Weight 83'
         REPW84       = 'Replicate Weight 84'
         REPW85       = 'Replicate Weight 85'
         REPW86       = 'Replicate Weight 86'
         REPW87       = 'Replicate Weight 87'
         REPW88       = 'Replicate Weight 88'
         CSOURCE      = 'Method of Interview'
         P135         = '4A Ungraded Offered'
         P140         = '4A Ungraded Enrollment'
         P145         = '4B Nursery/Prekindergarten Offered'
         P150         = '4B Nursery/Prekindergarten Enrollment'
         P155         = '4C Kindergarten Offered'
         P160         = '4C Kindergarten Enrollment'
         P165         = '4D Transitional Kindergarten Offered'
         P170         = '4D Transitional Kindergarten Enrollment'
         P175         = '4E Transitional First Grade Offered'
         P180         = '4E Transitional First Grade Enrollment'
         P185         = '4F First Grade Offered'
         P190         = '4F First Grade Enrollment'
         P195         = '4G Second Grade Offered'
         P200         = '4G Second Grade Enrollment'
         P205         = '4H Third Grade Offered'
         P210         = '4H Third Grade Enrollment'
         P215         = '4I Fourth Grade Offered'
         P220         = '4I Fourth Grade Enrollment'
         P225         = '4J Fifth Grade Offered'
         P230         = '4J Fifth Grade Enrollment'
         P235         = '4K Sixth Grade Offered'
         P240         = '4K Sixth Grade Enrollment'
         P245         = '4L Seventh Grade Offered'
         P250         = '4L Seventh Grade Enrollment'
         P255         = '4M Eighth Grade Offered'
         P260         = '4M Eighth Grade Enrollment'
         P265         = '4N Ninth Grade Offered'
         P270         = '4N Ninth Grade Enrollment'
         P275         = '4O Tenth Grade Offered'
         P280         = '4O Tenth Grade Enrollment'
         P285         = '4P Eleventh Grade Offered'
         P290         = '4P Eleventh Grade Enrollment'
         P295         = '4Q Twelfth Grade Offered'
         P300         = '4Q Twelfth Grade Enrollment'
         P305         = '5 Total Student Enrollment'
         P320         = '6A Hispanic or Latino Students'
         P330         = '6B White Students'
         P325         = '6C Black Students'
         P316         = '6D Asian Students'
         P318         = '6E Native Hawaiian/Pacific Islander Students'
         P310         = '6F American Indian/Alaska Native Students'
         P332         = '6G Students of Two or More Races'
         P335         = '7A Is School Coeducational'
         P340         = '7B Number of Male Students'
         P345         = '8A Students in 12th Grade Last Year'
         P350         = '8B Number of 12th Graders Last Year'
         P360         = '8D Percent to 4-Year College'
         P365         = '9A Length of School Day for Kindergarten'
         P370         = '9B Days Per Week for Kindergarten'
         P385         = '10 Full-Time Teachers'
         P390         = '10 More Than 3/4 Time Teachers'
         P395         = '10 More Than 1/2 Time Teachers'
         P400         = '10 More Than 1/4 Time Teachers'
         P405         = '10 Less Than 1/4 Time Teachers'
         P410         = '10 Total Number of Teachers'
         P415         = '11 Type of School'
         P420         = '12A School Supports Home Schooling'
         P425         = '12B School Located in Private Home'
         P430         = '13A Does School Have Religious Orientation'
         P435         = '13B School Affiliation'
         P440         = '13C Religious Orientation'
         P445         = '13C Type of Catholic School'
         P450         = '14 No Associations'
         P455         = '14 Accelerated Christian Education'
         P460         = '14 American Association of Christian Schools'
         P465         = '14 Association of Christian Schools International'
         P467         = '14 Association of Christian Teachers and Schools'
         P468         = '14 Association of Classical and Christian Schools'
         P470         = '14 Christian Schools International'
         P475         = '14 Council of Islamic Schools in North America'
         P480         = '14 Evangelical Lutheran Education Association'
         P485         = '14 Friends Council on Education'
         P490         = '14 General Conference of SDA Church'
         P492         = '14 Islamic School League of America'
         P495         = '14 Jesuit Secondary Education Association'
         P500         = '14 National Association of Episcopal Schools'
         P505         = '14 National Catholic Educational Association'
         P510         = '14 National Christian School Association'
         P515         = '14 National Society for Hebrew Day Schools'
         P520         = '14 Oral Roberts University Educational Fellowship'
         P523         = '14 Prizmah: Center for Jewish Day Schools'
         P530         = '14 Southern Baptist Association of Christian Schools'
         P535         = '14 Other Religious School Associations'
         P540         = '14 American Montessori Society'
         P542         = '14 Association Montessori International'
         P545         = '14 Other Montessori Associations'
         P550         = '14 Association of Military Colleges and Schools'
         P555         = '14 Association of Waldorf Schools of North America'
         P575         = '14 National Association of Private Special Education Centers'
         P580         = '14 Other Associations for Exceptional Children'
         P585         = '14 European Council for International Schools'
         P590         = '14 National Association for the Education of Young Children'
         P600         = '14 National Association of Laboratory Schools'
         P602         = '14 National Coalition of Girls'' Schools'
         P605         = '14 Other Special Emphasis Associations'
         P610         = '14 Alternative School Network'
         P620         = '14 National Association of Independent Schools'
         P622         = '14 State/Regional Independent School Association'
         P630         = '14 National Independent Private Schools Association'
         P635         = '14 The Association of Boarding Schools'
         P640         = '14 Other School Associations'
         P645         = '15 Days in School Year'
         P650         = '16 Hours in School Day for Students'
         P655         = '16 Minutes in School Day for Students'
         P660         = '17 Library or Library Media Center'
         PPIN         = 'Permanent Identification Number'
         PINST        = 'School Name'
         PADDRS       = 'Mailing Address'
         PCITY        = 'Mailing City'
         PSTABB       = 'Mailing State Postal Code'
         PZIP         = 'Mailing Zip Code'
         PZIP4        = 'Mailing Zip4 Code'
         PPHONE       = 'School phone number'
         PCNTY        = 'ANSI County Code'
         PCNTY20      = 'ANSI County Code + State Code'
         PCNTNM       = 'County Name'
         PL_ADD       = 'Location Address'
         PL_CIT       = 'Location City'
         PL_STABB     = 'Location State Postal Code'
         PL_ZIP       = 'Location Zip Code'
         PL_ZIP4      = 'Location Zip4 Code'
         REGION       = 'Census Region'
         PSTANSI      = 'ANSI State Code (physical location of school)'
         ULOCALE20    = 'Urban-centric Locale Code'
         LATITUDE20   = 'Latitude '
         LONGITUDE20  = 'Longitude'
         SLDLST20     = 'State Legislative District - Lower'
         SLDUST20     = 'State Legislative District - Upper'
         STCD20       = '114th Congressional District'
         LOGR2020     = '2019-20 Lowest Grade Level Recode'
         HIGR2020     = '2019-20 Highest Grade Level Recode'
         FRAME        = 'Universe frame to which  school belongs'
         TABFLAG      = 'Tabulation Flag'
         TYPOLOGY     = 'School Typology'
         RELIG        = 'Affiliation'
         ORIENT       = 'School Orientation'
         DIOCESE      = 'Diocese or archdiocese for Catholic schools'
         LEVEL        = 'Level of Instruction'
         LEVEL2       = 'Level of Instruction 2'
         NUMSTUDS     = 'Total Number of Students (K-12, UG)'
         SIZE         = 'Size of School (K-12, UG)'
         NUMTEACH     = 'Number of K-12 Teachers (FTE)'
         UCOMMTYP     = 'Urban-centric Community Type'
         TOTHRS       = 'Length of School Day in Hours'
         MALES        = 'Number of Male Students (K-12, UG)'
         F_P135       = 'Imputation Flag for P135'
         F_P140       = 'Imputation Flag for P140'
         F_P145       = 'Imputation Flag for P145'
         F_P150       = 'Imputation Flag for P150'
         F_P155       = 'Imputation Flag for P155'
         F_P160       = 'Imputation Flag for P160'
         F_P165       = 'Imputation Flag for P165'
         F_P170       = 'Imputation Flag for P170'
         F_P175       = 'Imputation Flag for P175'
         F_P180       = 'Imputation Flag for P180'
         F_P185       = 'Imputation Flag for P185'
         F_P190       = 'Imputation Flag for P190'
         F_P195       = 'Imputation Flag for P195'
         F_P200       = 'Imputation Flag for P200'
         F_P205       = 'Imputation Flag for P205'
         F_P210       = 'Imputation Flag for P210'
         F_P215       = 'Imputation Flag for P215'
         F_P220       = 'Imputation Flag for P220'
         F_P225       = 'Imputation Flag for P225'
         F_P230       = 'Imputation Flag for P230'
         F_P235       = 'Imputation Flag for P235'
         F_P240       = 'Imputation Flag for P240'
         F_P245       = 'Imputation Flag for P245'
         F_P250       = 'Imputation Flag for P250'
         F_P255       = 'Imputation Flag for P255'
         F_P260       = 'Imputation Flag for P260'
         F_P265       = 'Imputation Flag for P265'
         F_P270       = 'Imputation Flag for P270'
         F_P275       = 'Imputation Flag for P275'
         F_P280       = 'Imputation Flag for P280'
         F_P285       = 'Imputation Flag for P285'
         F_P290       = 'Imputation Flag for P290'
         F_P295       = 'Imputation Flag for P295'
         F_P300       = 'Imputation Flag for P300'
         F_P305       = 'Imputation Flag for P305'
         F_P320       = 'Imputation Flag for P320'
         F_P330       = 'Imputation Flag for P330'
         F_P325       = 'Imputation Flag for P325'
         F_P316       = 'Imputation Flag for P316'
         F_P318       = 'Imputation Flag for P318'
         F_P310       = 'Imputation Flag for P310'
         F_P332       = 'Imputation Flag for P332'
         F_P335       = 'Imputation Flag for P335'
         F_P340       = 'Imputation Flag for P340'
         F_P345       = 'Imputation Flag for P345'
         F_P350       = 'Imputation Flag for P350'
         F_P360       = 'Imputation Flag for P360'
         F_P365       = 'Imputation Flag for P365'
         F_P370       = 'Imputation Flag for P370'
         F_P385       = 'Imputation Flag for P385'
         F_P390       = 'Imputation Flag for P390'
         F_P395       = 'Imputation Flag for P395'
         F_P400       = 'Imputation Flag for P400'
         F_P405       = 'Imputation Flag for P405'
         F_P410       = 'Imputation Flag for P410'
         F_P415       = 'Imputation Flag for P415'
         F_P420       = 'Imputation Flag for P420'
         F_P425       = 'Imputation Flag for P425'
         F_P430       = 'Imputation Flag for P430'
         F_P435       = 'Imputation Flag for P435'
         F_P440       = 'Imputation Flag for P440'
         F_P445       = 'Imputation Flag for P445'
         F_P450       = 'Imputation Flag for P450'
         F_P455       = 'Imputation Flag for P455'
         F_P460       = 'Imputation Flag for P460'
         F_P465       = 'Imputation Flag for P465'
         F_P467       = 'Imputation Flag for P467'
         F_P468       = 'Imputation Flag for P468'
         F_P470       = 'Imputation Flag for P470'
         F_P475       = 'Imputation Flag for P475'
         F_P480       = 'Imputation Flag for P480'
         F_P485       = 'Imputation Flag for P485'
         F_P490       = 'Imputation Flag for P490'
         F_P492       = 'Imputation Flag for P492'
         F_P495       = 'Imputation Flag for P495'
         F_P500       = 'Imputation Flag for P500'
         F_P505       = 'Imputation Flag for P505'
         F_P510       = 'Imputation Flag for P510'
         F_P515       = 'Imputation Flag for P515'
         F_P520       = 'Imputation Flag for P520'
         F_P523       = 'Imputation Flag for P523'
         F_P530       = 'Imputation Flag for P530'
         F_P535       = 'Imputation Flag for P535'
         F_P540       = 'Imputation Flag for P540'
         F_P542       = 'Imputation Flag for P542'
         F_P545       = 'Imputation Flag for P545'
         F_P550       = 'Imputation Flag for P550'
         F_P555       = 'Imputation Flag for P555'
         F_P575       = 'Imputation Flag for P575'
         F_P580       = 'Imputation Flag for P580'
         F_P585       = 'Imputation Flag for P585'
         F_P590       = 'Imputation Flag for P590'
         F_P600       = 'Imputation Flag for P600'
         F_P602       = 'Imputation Flag for P602'
         F_P605       = 'Imputation Flag for P605'
         F_P610       = 'Imputation Flag for P610'
         F_P620       = 'Imputation Flag for P620'
         F_P622       = 'Imputation Flag for P622'
         F_P630       = 'Imputation Flag for P630'
         F_P635       = 'Imputation Flag for P635'
         F_P640       = 'Imputation Flag for P640'
         F_P645       = 'Imputation Flag for P645'
         F_P650       = 'Imputation Flag for P650'
         F_P655       = 'Imputation Flag for P655'
         F_P660       = 'Imputation Flag for P660'
         S_KG         = 'Total Number of Kindergarten Students'
         P_INDIAN     = 'Percentage of American Indian or Alaskan Native Students'
         P_ASIAN      = 'Percentage of Asian Students'
         P_PACIFIC    = 'Percentage of Native Hawaiian or Pacific Islander students'
         P_HISP       = 'Percentage of Hispanic Students'
         P_WHITE      = 'Percentage of White Students'
         P_BLACK      = 'Percentage of Black Students'
         P_TR         = 'Percentage of Students of Two or More Races'
         STTCH_RT     = 'Student Teacher Ratio';

   /* Permanently apply user-defined formats to the data */
   format CSOURCE CSOURCEF.
          P135 P135F.
          P145 P145F.
          P155 P155F.
          P165 P165F.
          P175 P175F.
          P185 P185F.
          P195 P195F.
          P205 P205F.
          P215 P215F.
          P225 P225F.
          P235 P235F.
          P245 P245F.
          P255 P255F.
          P265 P265F.
          P275 P275F.
          P285 P285F.
          P295 P295F.
          P335 P335F.
          P345 P345F.
          P365 P365F.
          P415 P415F.
          P420 P420F.
          P425 P425F.
          P430 P430F.
          P435 P435F.
          P440 P440F.
          P445 P445F.
          P450 P450F.
          P455 P455F.
          P460 P460F.
          P465 P465F.
          P467 P467F.
          P468 P468F.
          P470 P470F.
          P475 P475F.
          P480 P480F.
          P485 P485F.
          P490 P490F.
          P492 P492F.
          P495 P495F.
          P500 P500F.
          P505 P505F.
          P510 P510F.
          P515 P515F.
          P520 P520F.
          P523 P523F.
          P530 P530F.
          P535 P535F.
          P540 P540F.
          P542 P542F.
          P545 P545F.
          P550 P550F.
          P555 P555F.
          P575 P575F.
          P580 P580F.
          P585 P585F.
          P590 P590F.
          P600 P600F.
          P602 P602F.
          P605 P605F.
          P610 P610F.
          P620 P620F.
          P622 P622F.
          P630 P630F.
          P635 P635F.
          P640 P640F.
          P660 P660F.
          REGION REGIONF.
          PSTANSI $PSTANSIF.
          ULOCALE20 ULOCALE20F.
          LOGR2020 LOGR2020F.
          HIGR2020 HIGR2020F.
          FRAME $FRAMEF.
          TABFLAG TABFLAGF.
          TYPOLOGY TYPOLOGYF.
          RELIG RELIGF.
          ORIENT ORIENTF.
          DIOCESE $DIOCESEF.
          LEVEL LEVELF.
          LEVEL2 LEVEL2F.
          SIZE SIZEF.
          UCOMMTYP UCOMMTYPF.
          F_P135 F_P135F.
          F_P140 F_P140F.
          F_P145 F_P145F.
          F_P150 F_P150F.
          F_P155 F_P155F.
          F_P160 F_P160F.
          F_P165 F_P165F.
          F_P170 F_P170F.
          F_P175 F_P175F.
          F_P180 F_P180F.
          F_P185 F_P185F.
          F_P190 F_P190F.
          F_P195 F_P195F.
          F_P200 F_P200F.
          F_P205 F_P205F.
          F_P210 F_P210F.
          F_P215 F_P215F.
          F_P220 F_P220F.
          F_P225 F_P225F.
          F_P230 F_P230F.
          F_P235 F_P235F.
          F_P240 F_P240F.
          F_P245 F_P245F.
          F_P250 F_P250F.
          F_P255 F_P255F.
          F_P260 F_P260F.
          F_P265 F_P265F.
          F_P270 F_P270F.
          F_P275 F_P275F.
          F_P280 F_P280F.
          F_P285 F_P285F.
          F_P290 F_P290F.
          F_P295 F_P295F.
          F_P300 F_P300F.
          F_P305 F_P305F.
          F_P320 F_P320F.
          F_P330 F_P330F.
          F_P325 F_P325F.
          F_P316 F_P316F.
          F_P318 F_P318F.
          F_P310 F_P310F.
          F_P332 F_P332F.
          F_P335 F_P335F.
          F_P340 F_P340F.
          F_P345 F_P345F.
          F_P350 F_P350F.
          F_P360 F_P360F.
          F_P365 F_P365F.
          F_P370 F_P370F.
          F_P385 F_P385F.
          F_P390 F_P390F.
          F_P395 F_P395F.
          F_P400 F_P400F.
          F_P405 F_P405F.
          F_P410 F_P410F.
          F_P415 F_P415F.
          F_P420 F_P420F.
          F_P425 F_P425F.
          F_P430 F_P430F.
          F_P435 F_P435F.
          F_P440 F_P440F.
          F_P445 F_P445F.
          F_P450 F_P450F.
          F_P455 F_P455F.
          F_P460 F_P460F.
          F_P465 F_P465F.
          F_P467 F_P467F.
          F_P468 F_P468F.
          F_P470 F_P470F.
          F_P475 F_P475F.
          F_P480 F_P480F.
          F_P485 F_P485F.
          F_P490 F_P490F.
          F_P492 F_P492F.
          F_P495 F_P495F.
          F_P500 F_P500F.
          F_P505 F_P505F.
          F_P510 F_P510F.
          F_P515 F_P515F.
          F_P520 F_P520F.
          F_P523 F_P523F.
          F_P530 F_P530F.
          F_P535 F_P535F.
          F_P540 F_P540F.
          F_P542 F_P542F.
          F_P545 F_P545F.
          F_P550 F_P550F.
          F_P555 F_P555F.
          F_P575 F_P575F.
          F_P580 F_P580F.
          F_P585 F_P585F.
          F_P590 F_P590F.
          F_P600 F_P600F.
          F_P602 F_P602F.
          F_P605 F_P605F.
          F_P610 F_P610F.
          F_P620 F_P620F.
          F_P622 F_P622F.
          F_P630 F_P630F.
          F_P635 F_P635F.
          F_P640 F_P640F.
          F_P645 F_P645F.
          F_P650 F_P650F.
          F_P655 F_P655F.
          F_P660 F_P660F.;
run;

/* Display data file contents */
proc contents data=pss.pss1920_pu varnum;
   title 'Public-use Private School Survey (PSS), 2019-2020';
run;